qui {
noisily {
	/*******************************************************/
	/*** Step 1.11. Membership & oil dummies ***/
	/*******************************************************/

/* 1.11.1. International organizations */

/* 
To gain panel data on membership of international organizations/successor countries, we construct dummy variables indicating membership of:
	- EU
	- former Sovjet states
	- former Yugoslav states
	- NATO
	- AU
	- ASEAN
	
* We also construct a dummy for independence-by-referendum, source: Qvortrup (2014)
* We also construct a dummy for oil exporters, source: Fearon & Laitin (2013)
*/
}

/* 1.11.1.1. Define membership dummies */

	* EU dummy
	** Source: https://www.europarl.europa.eu/external/html/euenlargement/default_en.htm

	gen EU_dummy = 0
	replace EU_dummy = 1 if cntry == "Belgium" & year >= 1952
	replace EU_dummy = 1 if cntry == "German Federal Republic" & year >= 1952
	replace EU_dummy = 1 if cntry == "Germany" & year >= 1952
	replace EU_dummy = 1 if cntry == "Netherlands" & year >= 1952
	replace EU_dummy = 1 if cntry == "Luxembourg" & year >= 1952
	replace EU_dummy = 1 if cntry == "France" & year >= 1952
	replace EU_dummy = 1 if cntry == "Italy" & year >= 1952
	replace EU_dummy = 1 if cntry == "Ireland" & year >= 1973
	replace EU_dummy = 1 if cntry == "United Kingdom" & year >= 1973
	replace EU_dummy = 1 if cntry == "Denmark" & year >= 1973
	replace EU_dummy = 1 if cntry == "Greece" & year >= 1981
	replace EU_dummy = 1 if cntry == "Spain" & year >= 1986
	replace EU_dummy = 1 if cntry == "Portugal" & year >= 1986
	replace EU_dummy = 1 if cntry == "German Democratic Republic" & year >= 1990
	replace EU_dummy = 1 if cntry == "Austria" & year >= 1995
	replace EU_dummy = 1 if cntry == "Sweden" & year >= 1995
	replace EU_dummy = 1 if cntry == "Finland" & year >= 1995
	replace EU_dummy = 1 if cntry == "Malta" & year >= 2004
	replace EU_dummy = 1 if cntry == "Cyprus" & year >= 2004
	replace EU_dummy = 1 if cntry == "Estonia" & year >= 2004
	replace EU_dummy = 1 if cntry == "Latvia" & year >= 2004
	replace EU_dummy = 1 if cntry == "Lithuania" & year >= 2004
	replace EU_dummy = 1 if cntry == "Poland" & year >= 2004
	replace EU_dummy = 1 if cntry == "Czech Republic" & year >= 2004
	replace EU_dummy = 1 if cntry == "Slovakia" & year >= 2004
	replace EU_dummy = 1 if cntry == "Slovenia" & year >= 2004
	replace EU_dummy = 1 if cntry == "Hungary" & year >= 2004
	replace EU_dummy = 1 if cntry == "Bulgaria" & year >= 2007
	replace EU_dummy = 1 if cntry == "Romania" & year >= 2007
	replace EU_dummy = 1 if cntry == "Croatia" & year >= 2013
	
	* Soviet dummy
	gen soviet_dummy = 0
	replace soviet_dummy = 1 if cntry == "Russia"
	replace soviet_dummy = 1 if cntry == "Ukraine"
	replace soviet_dummy = 1 if cntry == "Belarus"
	replace soviet_dummy = 1 if cntry == "Uzbekistan"
	replace soviet_dummy = 1 if cntry == "Kazakhstan"
	replace soviet_dummy = 1 if cntry == "Georgia"
	replace soviet_dummy = 1 if cntry == "Azerbaijan"
	replace soviet_dummy = 1 if cntry == "Lithuania"
	replace soviet_dummy = 1 if cntry == "Moldova"
	replace soviet_dummy = 1 if cntry == "Latvia"
	replace soviet_dummy = 1 if cntry == "Kyrgyz Republic"
	replace soviet_dummy = 1 if cntry == "Tajikistan"
	replace soviet_dummy = 1 if cntry == "Armenia"
	replace soviet_dummy = 1 if cntry == "Turkmenistan"
	replace soviet_dummy = 1 if cntry == "Estonia"

	* Yugoslav dummy
	** Source: https://en.wikipedia.org/wiki/Yugoslavia#New_states

	gen yugoslav_dummy = 0
	replace yugoslav_dummy = 1 if cntry == "Serbia"
	replace yugoslav_dummy = 1 if cntry == "Croatia"
	replace yugoslav_dummy = 1 if cntry == "Bosnia and Herzegovina"
	replace yugoslav_dummy = 1 if cntry == "Slovenia"
	replace yugoslav_dummy = 1 if cntry == "Montenegro"
	replace yugoslav_dummy = 1 if cntry == "Macedonia"
	replace yugoslav_dummy = 1 if cntry == "Kosovo"

	* Independence-by-referendum dummy
	** Source: Qvortrup (2014)

	gen referendum_dummy = 0
	replace referendum_dummy = 1 if cntry == "Denmark"
	replace referendum_dummy = 1 if cntry == "Mongolia"
	replace referendum_dummy = 1 if cntry == "Cambodia"
	replace referendum_dummy = 1 if cntry == "Guinea"
	replace referendum_dummy = 1 if cntry == "Samoa"
	replace referendum_dummy = 1 if cntry == "Jamaica"
	replace referendum_dummy = 1 if cntry == "Algeria"
	replace referendum_dummy = 1 if cntry == "Singapore"
	replace referendum_dummy = 1 if cntry == "Malta"
	replace referendum_dummy = 1 if cntry == "Micronesia"
	replace referendum_dummy = 1 if cntry == "Lithuania"
	replace referendum_dummy = 1 if cntry == "Estonia"
	replace referendum_dummy = 1 if cntry == "Latvia"
	replace referendum_dummy = 1 if cntry == "Georgia"
	replace referendum_dummy = 1 if cntry == "Ukraine"
	replace referendum_dummy = 1 if cntry == "Croatia"
	replace referendum_dummy = 1 if cntry == "Macedonia"
	replace referendum_dummy = 1 if cntry == "Armenia"
	replace referendum_dummy = 1 if cntry == "Turkmenistan"
	replace referendum_dummy = 1 if cntry == "Uzbekistan"
	replace referendum_dummy = 1 if cntry == "Bosnia and Herzegovina"
	replace referendum_dummy = 1 if cntry == "Eritreria"
	replace referendum_dummy = 1 if cntry == "Palau"
	replace referendum_dummy = 1 if cntry == "East Timor"
	replace referendum_dummy = 1 if cntry == "Montenegro"
	replace referendum_dummy = 1 if cntry == "South Sudan"

	* NATO dummy
	** Source: https://en.wikipedia.org/wiki/Member_states_of_NATO

	gen NATO_dummy = 0
	replace NATO_dummy = 1 if cntry == "Belgium" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Canada" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Denmark" & year >= 1949
	replace NATO_dummy = 1 if cntry == "France" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Iceland" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Italy" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Luxembourg" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Netherlands" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Norway" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Portugal" & year >= 1949
	replace NATO_dummy = 1 if cntry == "United Kingdom" & year >= 1949
	replace NATO_dummy = 1 if cntry == "United States of America" & year >= 1949
	replace NATO_dummy = 1 if cntry == "Greece" & year >= 1952
	replace NATO_dummy = 1 if cntry == "Germany" & year >= 1955
	replace NATO_dummy = 1 if cntry == "German Federal Republic" & year >= 1955
	replace NATO_dummy = 1 if cntry == "Spain" & year >= 1982
	replace NATO_dummy = 1 if cntry == "Czech Republic" & year >= 1999
	replace NATO_dummy = 1 if cntry == "Hungary" & year >= 1999
	replace NATO_dummy = 1 if cntry == "Poland" & year >= 1999
	replace NATO_dummy = 1 if cntry == "Bulgaria" & year >= 2004
	replace NATO_dummy = 1 if cntry == "Estonia" & year >= 2004
	replace NATO_dummy = 1 if cntry == "Latvia" & year >= 2004
	replace NATO_dummy = 1 if cntry == "Lithuania" & year >= 2004
	replace NATO_dummy = 1 if cntry == "Romania" & year >= 2004
	replace NATO_dummy = 1 if cntry == "Slovakia" & year >= 2004
	replace NATO_dummy = 1 if cntry == "Slovenia" & year >= 2004
	replace NATO_dummy = 1 if cntry == "Albania" & year >= 2009
	replace NATO_dummy = 1 if cntry == "Croatia" & year >= 2009
	replace NATO_dummy = 1 if cntry == "Montenegro" & year >= 2017

	* African union dummy
	** Source: https://en.wikipedia.org/wiki/Member_states_of_the_African_Union

	gen AU_dummy = 0
	replace AU_dummy = 1 if cntry == "Algeria" & year >= 1963
	replace AU_dummy = 1 if cntry == "Benin" & year >= 1963
	replace AU_dummy = 1 if cntry == "Burkina Faso" & year >= 1963
	replace AU_dummy = 1 if cntry == "Burundi" & year >= 1963
	replace AU_dummy = 1 if cntry == "Cameroon" & year >= 1963
	replace AU_dummy = 1 if cntry == "Central African Republic" & year >= 1963
	replace AU_dummy = 1 if cntry == "Chad" & year >= 1963
	replace AU_dummy = 1 if cntry == "Democratic Republic of the Congo" & year >= 1963
	replace AU_dummy = 1 if cntry == "Egypt" & year >= 1963
	replace AU_dummy = 1 if cntry == "Egypt" & year >= 1963
	replace AU_dummy = 1 if cntry == "Ethiopia" & year >= 1963
	replace AU_dummy = 1 if cntry == "Gabon" & year >= 1963
	replace AU_dummy = 1 if cntry == "Ghana" & year >= 1963
	replace AU_dummy = 1 if cntry == "Guinea" & year >= 1963
	replace AU_dummy = 1 if cntry == "Ivory Coast" & year >= 1963
	replace AU_dummy = 1 if cntry == "Liberia" & year >= 1963
	replace AU_dummy = 1 if cntry == "Libya" & year >= 1963
	replace AU_dummy = 1 if cntry == "Madagascar" & year >= 1963
	replace AU_dummy = 1 if cntry == "Mali" & year >= 1963
	replace AU_dummy = 1 if cntry == "Mauritania" & year >= 1963
	replace AU_dummy = 1 if cntry == "Niger" & year >= 1963
	replace AU_dummy = 1 if cntry == "Nigeria" & year >= 1963
	replace AU_dummy = 1 if cntry == "Congo" & year >= 1963
	replace AU_dummy = 1 if cntry == "Ruanda" & year >= 1963
	replace AU_dummy = 1 if cntry == "Senegal" & year >= 1963
	replace AU_dummy = 1 if cntry == "Senegal" & year >= 1963
	replace AU_dummy = 1 if cntry == "Sierra Leone" & year >= 1963
	replace AU_dummy = 1 if cntry == "Somalia" & year >= 1963
	replace AU_dummy = 1 if cntry == "Sudan" & year >= 1963
	replace AU_dummy = 1 if cntry == "Tanzania" & year >= 1963
	replace AU_dummy = 1 if cntry == "Togo" & year >= 1963
	replace AU_dummy = 1 if cntry == "Tunisia" & year >= 1963
	replace AU_dummy = 1 if cntry == "Uganda" & year >= 1963
	replace AU_dummy = 1 if cntry == "Kenya" & year >= 1963
	replace AU_dummy = 1 if cntry == "Malawi" & year >= 1964
	replace AU_dummy = 1 if cntry == "Zambia" & year >= 1964
	replace AU_dummy = 1 if cntry == "Gambia" & year >= 1965
	replace AU_dummy = 1 if cntry == "Botswana" & year >= 1966
	replace AU_dummy = 1 if cntry == "Basutoland (Lesotho)" & year >= 1966
	replace AU_dummy = 1 if cntry == "Mauritius" & year >= 1968
	replace AU_dummy = 1 if cntry == "Swaziland" & year >= 1968
	replace AU_dummy = 1 if cntry == "Equatorial Guinea" & year >= 1968
	replace AU_dummy = 1 if cntry == "Guinea-Bissau" & year >= 1973
	replace AU_dummy = 1 if cntry == "Cape Verde" & year >= 1975
	replace AU_dummy = 1 if cntry == "Comoros" & year >= 1975
	replace AU_dummy = 1 if cntry == "Mozambique" & year >= 1975
	replace AU_dummy = 1 if cntry == "Sao Tome and Principe" & year >= 1975
	replace AU_dummy = 1 if cntry == "Seychelles" & year >= 1976
	replace AU_dummy = 1 if cntry == "Djibouti" & year >= 1977
	replace AU_dummy = 1 if cntry == "Angola" & year >= 1979
	replace AU_dummy = 1 if cntry == "Zimbabwe" & year >= 1980
	replace AU_dummy = 1 if cntry == "Namibia" & year >= 1990
	replace AU_dummy = 1 if cntry == "Eritreria" & year >= 1993
	replace AU_dummy = 1 if cntry == "South Africa" & year >= 1994
	replace AU_dummy = 1 if cntry == "South Sudan" & year >= 2011
	replace AU_dummy = 1 if cntry == "Morocco" & year >= 1963 & year <= 1984 | cntry == "Morocco" & year == 2017
	replace AU_dummy = 1 if cntry == "Zanzibar" & year >= 1963 & year <= 1964

	* ASEAN dummy
	** Source: https://en.wikipedia.org/wiki/Member_states_of_the_Association_of_Southeast_Asian_Nations

	gen ASEAN_dummy = 0
	replace ASEAN_dummy = 1 if cntry == "Indonesia" & year >= 1967
	replace ASEAN_dummy = 1 if cntry == "Malaysia" & year >= 1967
	replace ASEAN_dummy = 1 if cntry == "Phillipines" & year >= 1967
	replace ASEAN_dummy = 1 if cntry == "Singapore" & year >= 1967
	replace ASEAN_dummy = 1 if cntry == "Thailand" & year >= 1967
	replace ASEAN_dummy = 1 if cntry == "Brunei" & year >= 1984
	replace ASEAN_dummy = 1 if cntry == "Vietnam" & year >= 1995
	replace ASEAN_dummy = 1 if cntry == "Laos" & year >= 1997
	replace ASEAN_dummy = 1 if cntry == "Myanmar" & year >= 1997
	replace ASEAN_dummy = 1 if cntry == "Cambodia" & year >= 1999

	* Label variables
	label var EU_dummy "Dummy for EU-membership"
	label var soviet_dummy "Dummy for former Soviet member states"
	label var yugoslav_dummy "Dummy for former Yugoslavian member states"
	label var referendum_dummy "Dummy for independence-by-referendum"
	label var AU_dummy "Dummy for African Union-membership"
	label var ASEAN_dummy "Dummy for ASEAN-membership"

noisily {
/* 1.11.2. Oil exporters */
/*
To gain panel data on oil exporters, we also include an 'oil-dummy' equal to 1 whenever value of oil exports exceeds 1/3th of total export revenues.
* Source: Fearon & Laitin (2013).
* Note: data only available up to 2008, extended to 2016 using WDI data on fuel export share in total exports.
*/
}

/* 1.11.2.1. Load data */
cd ..
cd ".\3. Intermediary results"
merge 1:1 year cntrycode_GM2 using GM2, keepusing(dummy_oil_GM2)
drop if _merge == 2
drop _merge
merge 1:1 year cntrycode_WDI using WDI_doil, keepusing(Fuel_exports_WDI)
drop if _merge == 2
drop _merge

/* 1.11.2.2. Replace missings */
* Extend forward

xtset cntrycode year
replace dummy_oil = 0 if dummy_oil == . & year < 2009  // Data until 2008
replace dummy_oil = 1 if Fuel_exports_WDI >= 66.666 & Fuel_exports_WDI != . & year > 2008
replace dummy_oil = 0 if dummy_oil == . & year > 2008
drop Fuel_exports_WDI
rename dummy_oil doil 

/* 1.11.2.3. Label variable */
label var doil "Dummy for oil exporting state"

* Reroute to directory containing dofiles
cd ..
cd ".\1. Dofiles"
}
